/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.container;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.init.ModContainerTypes;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.container.TravelersBackpackBaseContainer;
import com.tiviacz.travelersbackpack.inventory.container.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class TravelersBackpackItemContainer
extends TravelersBackpackBaseContainer {
    public TravelersBackpackItemContainer(int windowID, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowID, playerInventory, TravelersBackpackItemContainer.createInventory(playerInventory, data));
    }

    public TravelersBackpackItemContainer(int windowID, PlayerInventory playerInventory, ITravelersBackpackInventory inventory) {
        super((ContainerType)ModContainerTypes.TRAVELERS_BACKPACK_ITEM.get(), windowID, playerInventory, inventory);
    }

    private static TravelersBackpackInventory createInventory(PlayerInventory playerInventory, PacketBuffer data) {
        ItemStack stack;
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        byte screenID = data.readByte();
        if (screenID == 1) {
            stack = playerInventory.field_70458_d.func_184582_a(EquipmentSlotType.MAINHAND);
        } else if (data.writerIndex() == 5) {
            int entityId = data.readInt();
            stack = CapabilityUtils.getWearingBackpack((PlayerEntity)playerInventory.field_70458_d.field_70170_p.func_73045_a(entityId));
            if (stack.func_77973_b() instanceof TravelersBackpackItem) {
                return CapabilityUtils.getBackpackInv((PlayerEntity)playerInventory.field_70458_d.field_70170_p.func_73045_a(entityId));
            }
        } else {
            stack = CapabilityUtils.getWearingBackpack(playerInventory.field_70458_d);
        }
        if (stack.func_77973_b() instanceof TravelersBackpackItem) {
            if (screenID == 2) {
                return CapabilityUtils.getBackpackInv(playerInventory.field_70458_d);
            }
            if (screenID == 1) {
                return new TravelersBackpackInventory(stack, playerInventory.field_70458_d, screenID);
            }
        }
        throw new IllegalStateException("ItemStack is not correct! " + stack);
    }

    @Override
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (clickTypeIn == ClickType.SWAP) {
            ItemStack stack = player.field_71071_by.func_70301_a(dragType);
            ItemStack currentItem = player.field_71071_by.func_70448_g();
            if (!currentItem.func_190926_b() && stack == currentItem) {
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    @Override
    public void addPlayerInventoryAndHotbar(PlayerInventory playerInv, int currentItemIndex) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInv, x + y * 9 + 9, 44 + x * 18, 125 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            if (x == currentItemIndex && this.inventory.getScreenID() == 1) {
                this.func_75146_a(new DisabledSlot((IInventory)playerInv, x, 44 + x * 18, 183));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)playerInv, x, 44 + x * 18, 183));
        }
    }
}

